using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace _c_dzekVrabac_K2025
{
    internal class Program
    {

        static int Rastojanje(int index1, int index2, List<(long,long)> jarboli)
        {
            return (int)Math.Abs(jarboli[index1].Item1 - jarboli[index2].Item1);
        }



        static void Main(string[] args)
        {

            // ucitavanje
            long n = long.Parse(Console.ReadLine());
            string[] ulaz1 = Console.ReadLine().Split(" ");
            string[] ulaz2 = Console.ReadLine().Split(" ");


            List <(long,long)> nesortirani = new List <(long,long)> ();
            for (int i = 0; i < n; i++)
            {
                nesortirani.Add((long.Parse(ulaz1[i]), long.Parse(ulaz2[i])));
            }

            // jer jarboli nisu nuzno sortirani! :DDD
            var jarboli = nesortirani.OrderBy(x => x.Item1).ToList();


            // jarbol(x,h)
            List<long> res = new List<long>();
            // mora da se inicijalizuje resenje
            for (int i = 0; i < n; i++)
            {
                res.Add(-1);
            }



            // 1. deo
            // l->d prolazak
            Stack<int> pom = new Stack<int> ();


            for (int i = 0; i < n ; i++)
            {
                while (pom.Count > 0 && jarboli[i].Item2 > jarboli[pom.Peek()].Item2)
                {
                    res[pom.Peek()] = i;
                    pom.Pop();
                }
                if (i<=n-2 && jarboli[i].Item2 < jarboli[i+1].Item2)
                {
                    res[i] = i+1;
                }
                else
                {
                    pom.Push(i);
                }
            }

            for(int i = 0; i<res.Count; i++)
            {
                //Console.WriteLine("{0} {1}", i, res[i]);
            }

            // 2. deo
            // d->l prolazak
            List<long> res2 = new List<long>();
            for (int i = 0; i < n; i++)
            {
                res2.Add(-1);
            }
            pom.Clear();


            for (int i = (int)n-1; i >= 0; i--)
            {
                while (pom.Count > 0 && jarboli[i].Item2 > jarboli[pom.Peek()].Item2)
                {
                    res2[pom.Peek()] = i;
                    pom.Pop();
                }
                if (i >= 1 && jarboli[i].Item2 < jarboli[i - 1].Item2)
                {
                        res2[i] = i - 1;
                }
                else
                {
                    pom.Push(i);
                }
            }

            for (int i = 0; i < res2.Count; i++)
            {
                //Console.WriteLine("{0} {1}", i, res2[i]);
            }

            
            for(int i = 0; i <n; i++)
            {
                // ovo su najblizi jarboli
                // levo i desno u odnosu na i jarbol
                long r = res[i];
                long r2 = res2[i];

                if (r == -1)
                    r = r2;
                else if (r2 > -1 && r>-1 && Rastojanje(i, (int)r2,jarboli) < Rastojanje(i, (int)r,jarboli))
                    r = r2;
                if (r > -1)
                    r = Rastojanje(i, (int)r, jarboli) - (jarboli[(int)r].Item2 - jarboli[i].Item2);

                res[i] = r;
            }

            var cmp = Comparer<(long, long)>.Create((a, b) => a.Item1.CompareTo(b.Item1));

            for (int i = 0; i < n; i++)
            {
                var jarbol = nesortirani[i];
                int index = jarboli.BinarySearch(jarbol, cmp);

                if (index < 0)
                {
                    Console.WriteLine(-1);
                    continue;
                }

                Console.WriteLine(res[index]);
            }



        }
    }
}